﻿//////////////////////////////////////////////
// ArrayAccessorDescriptor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkScripts
#include "../Functions/FunctionDefines.h"
#include "../Functions/FunctionParameterType.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>

// Standards
#include <functional>

/// Class ------------------------------------

namespace nkScripts
{
	using ArrayReadFunction = FunctionCallback ;
	using ArrayWriteFunction = std::function<void(const DataStack&)> ;

	struct ArrayAccessorDescriptor
	{
		// Callbacks
		ArrayReadFunction _readFunc ;
		ArrayWriteFunction _writeFunc ;

		// Le type de tableau à pourvoir
		FUNCTION_PARAMETER_TYPE _fieldType = FUNCTION_PARAMETER_TYPE::INT ;
		nkMemory::String _userTypeName ;
	} ;
}